/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import tools.tzdb.Ser;
import tools.tzdb.ZoneOffsetTransition;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = 6889046316657758795L;
    private final Month month;
    private final byte dom;
    private final DayOfWeek dow;
    private final LocalTime time;
    private final boolean timeEndOfDay;
    private final TimeDefinition timeDefinition;
    private final ZoneOffset standardOffset;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    public static ZoneOffsetTransitionRule of(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        Objects.requireNonNull(month, "month");
        Objects.requireNonNull(localTime, "time");
        Objects.requireNonNull(timeDefinition, "timeDefnition");
        Objects.requireNonNull(zoneOffset, "standardOffset");
        Objects.requireNonNull(zoneOffset2, "offsetBefore");
        Objects.requireNonNull(zoneOffset3, "offsetAfter");
        if (n < -28 || n > 31 || n == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (bl && !localTime.equals(LocalTime.MIDNIGHT)) {
            throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
        }
        if (localTime.getNano() != 0) {
            throw new IllegalArgumentException("Time's nano-of-second must be zero");
        }
        return new ZoneOffsetTransitionRule(month, n, dayOfWeek, localTime, bl, timeDefinition, zoneOffset, zoneOffset2, zoneOffset3);
    }

    ZoneOffsetTransitionRule(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        assert (localTime.getNano() == 0);
        this.month = month;
        this.dom = (byte)n;
        this.dow = dayOfWeek;
        this.time = localTime;
        this.timeEndOfDay = bl;
        this.timeDefinition = timeDefinition;
        this.standardOffset = zoneOffset;
        this.offsetBefore = zoneOffset2;
        this.offsetAfter = zoneOffset3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        int n = this.timeEndOfDay ? 86400 : this.time.toSecondOfDay();
        int n2 = this.standardOffset.getTotalSeconds();
        int n3 = this.offsetBefore.getTotalSeconds() - n2;
        int n4 = this.offsetAfter.getTotalSeconds() - n2;
        int n5 = n % 3600 == 0 ? (this.timeEndOfDay ? 24 : this.time.getHour()) : 31;
        int n6 = n2 % 900 == 0 ? n2 / 900 + 128 : 255;
        int n7 = n3 == 0 || n3 == 1800 || n3 == 3600 ? n3 / 1800 : 3;
        int n8 = n4 == 0 || n4 == 1800 || n4 == 3600 ? n4 / 1800 : 3;
        int n9 = this.dow == null ? 0 : this.dow.getValue();
        int n10 = (this.month.getValue() << 28) + (this.dom + 32 << 22) + (n9 << 19) + (n5 << 14) + (this.timeDefinition.ordinal() << 12) + (n6 << 4) + (n7 << 2) + n8;
        dataOutput.writeInt(n10);
        if (n5 == 31) {
            dataOutput.writeInt(n);
        }
        if (n6 == 255) {
            dataOutput.writeInt(n2);
        }
        if (n7 == 3) {
            dataOutput.writeInt(this.offsetBefore.getTotalSeconds());
        }
        if (n8 == 3) {
            dataOutput.writeInt(this.offsetAfter.getTotalSeconds());
        }
    }

    static ZoneOffsetTransitionRule readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        Month month = Month.of(n >>> 28);
        int n2 = ((n & 0xFC00000) >>> 22) - 32;
        int n3 = (n & 0x380000) >>> 19;
        DayOfWeek dayOfWeek = n3 == 0 ? null : DayOfWeek.of(n3);
        int n4 = (n & 0x7C000) >>> 14;
        TimeDefinition timeDefinition = TimeDefinition.values()[(n & 0x3000) >>> 12];
        int n5 = (n & 0xFF0) >>> 4;
        int n6 = (n & 0xC) >>> 2;
        int n7 = n & 3;
        LocalTime localTime = n4 == 31 ? LocalTime.ofSecondOfDay(dataInput.readInt()) : LocalTime.of(n4 % 24, 0);
        ZoneOffset zoneOffset = n5 == 255 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds((n5 - 128) * 900);
        ZoneOffset zoneOffset2 = n6 == 3 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n6 * 1800);
        ZoneOffset zoneOffset3 = n7 == 3 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n7 * 1800);
        return ZoneOffsetTransitionRule.of(month, n2, dayOfWeek, localTime, n4 == 24, timeDefinition, zoneOffset, zoneOffset2, zoneOffset3);
    }

    public Month getMonth() {
        return this.month;
    }

    public int getDayOfMonthIndicator() {
        return this.dom;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dow;
    }

    public LocalTime getLocalTime() {
        return this.time;
    }

    public boolean isMidnightEndOfDay() {
        return this.timeEndOfDay;
    }

    public TimeDefinition getTimeDefinition() {
        return this.timeDefinition;
    }

    public ZoneOffset getStandardOffset() {
        return this.standardOffset;
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }

    public ZoneOffsetTransition createTransition(int n) {
        LocalDate localDate;
        if (this.dom < 0) {
            localDate = LocalDate.of(n, this.month, this.month.length(IsoChronology.INSTANCE.isLeapYear(n)) + 1 + this.dom);
            if (this.dow != null) {
                localDate = localDate.with(TemporalAdjusters.previousOrSame(this.dow));
            }
        } else {
            localDate = LocalDate.of(n, this.month, (int)this.dom);
            if (this.dow != null) {
                localDate = localDate.with(TemporalAdjusters.nextOrSame(this.dow));
            }
        }
        if (this.timeEndOfDay) {
            localDate = localDate.plusDays(1L);
        }
        LocalDateTime localDateTime = LocalDateTime.of(localDate, this.time);
        LocalDateTime localDateTime2 = this.timeDefinition.createDateTime(localDateTime, this.standardOffset, this.offsetBefore);
        return new ZoneOffsetTransition(localDateTime2, this.offsetBefore, this.offsetAfter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ZoneOffsetTransitionRule) {
            ZoneOffsetTransitionRule zoneOffsetTransitionRule = (ZoneOffsetTransitionRule)object;
            return this.month == zoneOffsetTransitionRule.month && this.dom == zoneOffsetTransitionRule.dom && this.dow == zoneOffsetTransitionRule.dow && this.timeDefinition == zoneOffsetTransitionRule.timeDefinition && this.time.equals(zoneOffsetTransitionRule.time) && this.timeEndOfDay == zoneOffsetTransitionRule.timeEndOfDay && this.standardOffset.equals(zoneOffsetTransitionRule.standardOffset) && this.offsetBefore.equals(zoneOffsetTransitionRule.offsetBefore) && this.offsetAfter.equals(zoneOffsetTransitionRule.offsetAfter);
        }
        return false;
    }

    public int hashCode() {
        int n = (this.time.toSecondOfDay() + (this.timeEndOfDay ? 1 : 0) << 15) + (this.month.ordinal() << 11) + (this.dom + 32 << 5) + ((this.dow == null ? 7 : this.dow.ordinal()) << 2) + this.timeDefinition.ordinal();
        return n ^ this.standardOffset.hashCode() ^ this.offsetBefore.hashCode() ^ this.offsetAfter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TransitionRule[").append(this.offsetBefore.compareTo(this.offsetAfter) > 0 ? "Gap " : "Overlap ").append(this.offsetBefore).append(" to ").append(this.offsetAfter).append(", ");
        if (this.dow != null) {
            if (this.dom == -1) {
                stringBuilder.append(this.dow.name()).append(" on or before last day of ").append(this.month.name());
            } else if (this.dom < 0) {
                stringBuilder.append(this.dow.name()).append(" on or before last day minus ").append(-this.dom - 1).append(" of ").append(this.month.name());
            } else {
                stringBuilder.append(this.dow.name()).append(" on or after ").append(this.month.name()).append(' ').append(this.dom);
            }
        } else {
            stringBuilder.append(this.month.name()).append(' ').append(this.dom);
        }
        stringBuilder.append(" at ").append(this.timeEndOfDay ? "24:00" : this.time.toString()).append(" ").append((Object)this.timeDefinition).append(", standard offset ").append(this.standardOffset).append(']');
        return stringBuilder.toString();
    }

    public static enum TimeDefinition {
        UTC,
        WALL,
        STANDARD;


        public LocalDateTime createDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
            switch (this) {
                case UTC: {
                    int n = zoneOffset2.getTotalSeconds() - ZoneOffset.UTC.getTotalSeconds();
                    return localDateTime.plusSeconds(n);
                }
                case STANDARD: {
                    int n = zoneOffset2.getTotalSeconds() - zoneOffset.getTotalSeconds();
                    return localDateTime.plusSeconds(n);
                }
            }
            return localDateTime;
        }
    }
}

